/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.util;

import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.controls.ComboItem;
import com.kdjsystem.mlink.yellim.dao.DomemallDAO;
import com.kdjsystem.mlink.yellim.dao.PreferencesDAO;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dao.ShoppingmallDAO;
import com.kdjsystem.mlink.yellim.data.excel.MyDataManagerFactory;
import com.kdjsystem.mlink.yellim.data.excel.MyExcelManager;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductFolderDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.ui.PreferencesMallDialog;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PreferencesMallUtil {
    public String createProductFolder(String filePath) throws Exception {
        try {
            MyExcelManager readExcelManager = MyDataManagerFactory.createExcelManager(filePath);
            readExcelManager.loadData();
            List<List<String>> sheetContents = readExcelManager.getSheetContents(0, 2);
            ArrayList<ProductFolderDTO> items = new ArrayList<ProductFolderDTO>();
            for (List<String> list : sheetContents) {
                ProductFolderDTO dto = new ProductFolderDTO();
                dto.setCOMPNO(YDMASessonUtil.getCompnoInfo().getCompno());
                dto.setFOLDER(list.get(0).toString());
                dto.setCOMPAYNY_GOODS_CD(list.get(1).toString());
                items.add(dto);
            }
            int deleteRet = ProductDAO.get().deleteClearProductFolders();
            int insertRet = ProductDAO.get().insertProductFolders(items);
            return String.format("%s\uac74 \uc0ad\uc81c \ud6c4 %s\uac74 \ub4f1\ub85d\ud588\uc2b5\ub2c8\ub2e4.", deleteRet, insertRet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public String clearProductFolder() throws Exception {
        try {
            int deleteRet = ProductDAO.get().deleteClearProductFolders();
            return String.format("%s\uac74\uc774 \uc0ad\uc81c \ub418\uc5c8\uc2b5\ub2c8\ub2e4.", deleteRet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public int createExcelFormatProductFolder(String savePath) throws Exception {
        XSSFSheet prodmanager;
        XSSFCellStyle cs_center;
        XSSFWorkbook workbook;
        String[] headers;
        block6: {
            headers = new String[]{"\ud3f4\ub354\uc774\ub984(\uac80\uc0c9\uc81c\uc678:NOT_\uc2dc\uc791)", "\uc790\uccb4\uc0c1\ud488\ucf54\ub4dc"};
            workbook = new XSSFWorkbook();
            XSSFColor color_pass = new XSSFColor();
            color_pass.setIndexed((int)IndexedColors.GREY_40_PERCENT.getIndex());
            cs_center = workbook.createCellStyle();
            cs_center.setAlignment((short)2);
            cs_center.setFillForegroundColor(color_pass);
            cs_center.setFillPattern((short)1);
            cs_center.setWrapText(true);
            prodmanager = workbook.createSheet("\ud3f4\ub354\uc0c1\ud488\ucf54\ub4dc");
            if (prodmanager != null) break block6;
            return -1;
        }
        try {
            XSSFCellStyle cs_wrap = workbook.createCellStyle();
            cs_wrap.setWrapText(true);
            Row row_head2 = prodmanager.createRow(1);
            row_head2.setHeightInPoints(100.0f);
            row_head2.setRowStyle((CellStyle)cs_center);
            int i = 0;
            while (i < headers.length) {
                Cell cell = row_head2.createCell(i);
                cell.setCellValue(headers[i]);
                if (i == 0) {
                    prodmanager.setColumnWidth(i, 7000);
                } else {
                    prodmanager.setColumnWidth(i, 4000);
                }
                ++i;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(savePath);
            workbook.write((OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        return 0;
    }

    public String savePreferences(PreferencesMallDTO dto) throws Exception {
        String returnString = "";
        try {
            if (PreferencesDAO.get().isExistsPreferences()) {
                int result = ShopCommonDao.get().systemConfUpdate(dto);
                if (result != 0) {
                    returnString = "\uc815\uc0c1\uc801\uc73c\ub85c \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
                }
            } else {
                int result = ShopCommonDao.get().systemConfInsert(dto);
                if (result != 0) {
                    returnString = "\uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        return returnString;
    }

    public List<ShoppingmallDTO> searchShoppingMall(int index, String search) throws Exception {
        try {
            List<ShoppingmallDTO> result = ShoppingmallDAO.get().selectSearchPreferencesShoppingmallInfos(index, search);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<DomemallDTO> searchDomeMall(int index, String search) {
        try {
            List<DomemallDTO> result = DomemallDAO.get().selectSearchPreferencesDomeMallInfos(index, search);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String deleteProcess(boolean mallFlag, Object selectedObject) {
        String returnString = "";
        try {
            if (mallFlag) {
                ShoppingmallDTO info = (ShoppingmallDTO)selectedObject;
                int ret = ShoppingmallDAO.get().deleteShoppingMall(info.getSHOPCD(), info.getSHOPSEQ(), info.getSHOPPINGID());
                if (ret == 1) {
                    ShoppingmallDTO masterInfo = ShoppingmallDAO.get().selectShoppingMallMasterInfo(info.getSHOPCD());
                    int num = ShoppingmallDAO.get().selectShoppingMallMaxSeq(masterInfo.getSHOPCD());
                    ret = ShoppingmallDAO.get().updateShoppingMallMasterTradingInfo(String.valueOf(num), masterInfo.getSHOPCD());
                }
                returnString = ret == 1 ? "\uc0ad\uc81c\uac00 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4." : "\uc0ad\uc81c\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.";
            } else {
                DomemallDTO info = (DomemallDTO)selectedObject;
                int ret = DomemallDAO.get().deleteDomeMall(info.getSHOPCD(), info.getSHOPSEQ(), info.getSHOPPINGID());
                if (ret == 1) {
                    DomemallDTO masterInfo = DomemallDAO.get().selectDomeMallMasterInfo(info.getSHOPCD());
                    int num = DomemallDAO.get().selectDomeMallDetailQty(masterInfo.getSHOPCD());
                    ret = DomemallDAO.get().updateDomeMallMasterTradingInfo(String.valueOf(num), masterInfo.getSHOPCD());
                    if (ret == 1 && num == 0 && !mallFlag) {
                        ret = DomemallDAO.get().mergeMallUsingData(masterInfo.getSHOPCD(), masterInfo.getSHOPNM());
                    }
                    returnString = ret == 1 ? "\uc0ad\uc81c\uac00 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4." : "\uc0ad\uc81c\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.";
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ex.getMessage();
        }
        return returnString;
    }

    public List<ComboItem> getShoppingSiteComboItems(boolean mallFlag) {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>();
        try {
            if (mallFlag) {
                List<ShoppingmallDTO> infos = ShoppingmallDAO.get().selectTradingShoppingMallQuickInfo();
                for (ShoppingmallDTO info : infos) {
                    ComboItem item = new ComboItem();
                    item.setName(info.getSHOPNM());
                    item.setCode(info.getSHOPCD());
                    item.setSHOPINFO(info);
                    result.add(item);
                }
            } else {
                List<DomemallDTO> infos = DomemallDAO.get().selectTradingDomeMallQuickInfo();
                for (DomemallDTO info : infos) {
                    ComboItem item = new ComboItem();
                    item.setName(info.getSHOPNM());
                    item.setCode(info.getSHOPCD());
                    item.setDOMEINFO(info);
                    result.add(item);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return result;
    }

    public ComboItem getSelectedComboItem(Object info, boolean mallFlag) {
        ComboItem item = new ComboItem();
        try {
            if (mallFlag) {
                ShoppingmallDTO shopInfo = (ShoppingmallDTO)info;
                item.setName(shopInfo.getSHOPNM());
                item.setCode(shopInfo.getSHOPCD());
                item.setSHOPINFO(shopInfo);
            } else {
                DomemallDTO domeInfo = (DomemallDTO)info;
                item.setName(domeInfo.getSHOPNM());
                item.setCode(domeInfo.getSHOPCD());
                item.setDOMEINFO(domeInfo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return item;
    }

    public boolean isExistsUserID(ComboItem item, String id, boolean mallFlag) {
        try {
            if (mallFlag) {
                boolean ret = ShoppingmallDAO.get().isExistsUserID(id, item.getCode());
                return ret;
            }
            boolean ret = DomemallDAO.get().isExistsUserID(id, item.getCode());
            return ret;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
    }

    public boolean isExistsModifyUserID(String id, String shopCode, int shopSeq, boolean mallFlag) {
        try {
            if (mallFlag) {
                boolean ret = ShoppingmallDAO.get().isExistsUserID(id, shopCode, shopSeq);
                return ret;
            }
            boolean ret = DomemallDAO.get().isExistsUserID(id, shopCode, shopSeq);
            return ret;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
    }

    public String beforeSavingCheck(String shopGroup, boolean mallFlag) {
        String returnString = "";
        try {
            PreferencesMallDTO info;
            if (mallFlag && (info = PreferencesDAO.get().selectSystemConfig()) != null && info.getPRODDUP1().equals("Y") && shopGroup.length() == 0) {
                return "\uc0ac\uc5c5\uc790\ubcc4 \uadf8\ub8f9\uc744 \uc785\ub825\ud574\uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ex.getMessage();
        }
        return returnString;
    }

    public int getShoppingmallMaxSeq(String shopCode) {
        try {
            int result = ShoppingmallDAO.get().selectShoppingMallMaxSeq(shopCode);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public int registerShoppingMall(ShoppingmallDTO shopInfo) {
        try {
            int result = ShoppingmallDAO.get().insertShoppingMallDetailInfo(shopInfo);
            if (result == 1) {
                result = ShoppingmallDAO.get().updateShoppingMallMasterTradingInfo(String.valueOf(shopInfo.getSHOPSEQ()), shopInfo.getSHOPCD());
                return result;
            }
            return -1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public int registerDomeMall(DomemallDTO domeInfo) {
        try {
            int result = DomemallDAO.get().insertDomeMallDetailInfo(domeInfo);
            if (result == 1) {
                result = DomemallDAO.get().updateDomeMallMasterTradingInfo(String.valueOf(domeInfo.getSHOPSEQ()), domeInfo.getSHOPCD());
                return result;
            }
            return -1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public int modifyShoppingMall(ShoppingmallDTO shopInfo) {
        try {
            int result = ShoppingmallDAO.get().updateShoppingMallDetailInfo(shopInfo);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public int modifyDomeMall(DomemallDTO domeInfo) {
        try {
            int result = DomemallDAO.get().updateDomeMallDetailInfo(domeInfo);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public void getSearchShoppingManagerDome(int result, String search, GridTableViewer tableViewer_dome) {
        if (result == 0) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)PreferencesMallDialog.TITLE_SEARCH, (String)"\uac80\uc0c9\ud56d\ubaa9\uc744 \uccb4\ud06c\ud6c4\uc5d0 \uc9c4\ud589\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
            return;
        }
        if (search.length() > 0 && search.length() < 2) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)PreferencesMallDialog.TITLE_SEARCH, (String)"2\uae00\uc790 \uc774\uc0c1 \uc785\ub825\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
            return;
        }
        PreferencesDAO dao = PreferencesDAO.get();
        try {
            List<List<String>> contents = dao.getSearchconditionDome(result, search);
            tableViewer_dome.setInput(contents);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

