/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.felix.gogo.runtime.EOFError;
import org.apache.felix.gogo.runtime.SyntaxError;
import org.apache.felix.gogo.runtime.Token;
import org.apache.felix.gogo.runtime.Tokenizer;

public class Parser {
    protected final Tokenizer tz;
    protected final LinkedList<String> stack = new LinkedList();
    protected final List<Token> tokens = new ArrayList<Token>();
    protected final List<Statement> statements = new ArrayList<Statement>();
    private static final Pattern redirNoArg = Pattern.compile("[0-9]?>&[0-9-]|[0-9-]?<&[0-9-]");
    private static final Pattern redirArg = Pattern.compile("[0-9&]?>|[0-9]?>>|[0-9]?<|[0-9]?<>|<<<");
    private static final Pattern redirHereDoc = Pattern.compile("<<-?");

    public Parser(CharSequence line) {
        this.tz = new Tokenizer(line);
    }

    public List<Token> tokens() {
        return Collections.unmodifiableList(this.tokens);
    }

    public List<Statement> statements() {
        Collections.sort(this.statements, new Comparator<Statement>(){

            @Override
            public int compare(Statement o1, Statement o2) {
                return Integer.compare(o1.start, o2.start);
            }
        });
        return Collections.unmodifiableList(this.statements);
    }

    public Program program() {
        ArrayList<Executable> tokens = new ArrayList<Executable>();
        ArrayList<Executable> pipes = null;
        int start = this.tz.index - 1;
        while (true) {
            Token t;
            if ((t = this.next()) == null) {
                if (pipes != null) {
                    throw new EOFError(this.tz.line, this.tz.column, "unexpected EOT while looking for a statement after |", this.getMissing("pipe"), "0");
                }
                return new Program(this.whole(tokens, start), tokens);
            }
            if (Token.eq("}", t) || Token.eq(")", t)) {
                if (pipes != null) {
                    throw new EOFError(t.line, t.column, "unexpected token '" + t + "' while looking for a statement after |", this.getMissing("pipe"), "0");
                }
                this.push(t);
                return new Program(this.whole(tokens, start), tokens);
            }
            this.push(t);
            Statement ex = this.statement();
            t = this.next();
            if (t == null || Token.eq(";", t) || Token.eq("\n", t) || Token.eq("&", t) || Token.eq("&&", t) || Token.eq("||", t)) {
                if (pipes != null) {
                    pipes.add(ex);
                    tokens.add(new Pipeline(this.whole((List<? extends Token>)pipes, start), (List<Executable>)pipes));
                    pipes = null;
                } else {
                    tokens.add(ex);
                }
                if (t == null) {
                    return new Program(this.whole(tokens, start), tokens);
                }
                tokens.add(new Operator(t));
                continue;
            }
            if (Token.eq("|", t) || Token.eq("|&", t)) {
                if (pipes == null) {
                    pipes = new ArrayList<Executable>();
                }
                pipes.add(ex);
                pipes.add(new Operator(t));
                continue;
            }
            if (pipes != null) {
                pipes.add(ex);
                tokens.add(new Pipeline(this.whole(pipes, start), pipes));
                pipes = null;
            } else {
                tokens.add(ex);
            }
            this.push(t);
        }
    }

    protected void push(Token t) {
        this.tz.push(t);
    }

    protected Token next() {
        boolean pushed = this.tz.pushed != null;
        Token token = this.tz.next();
        if (!pushed && token != null) {
            this.tokens.add(token);
        }
        return token;
    }

    public Sequence sequence() {
        Token start = this.start("(", "sequence");
        this.expectNotNull();
        Program program = this.program();
        Token end = this.end(")");
        return new Sequence(this.whole(start, end), program);
    }

    public Closure closure() {
        Token start = this.start("{", "closure");
        this.expectNotNull();
        Program program = this.program();
        Token end = this.end("}");
        return new Closure(this.whole(start, end), program);
    }

    public Statement statement() {
        Token t;
        ArrayList<Token> tokens = new ArrayList<Token>();
        ArrayList<Token> redirs = new ArrayList<Token>();
        boolean needRedirArg = false;
        int start = this.tz.index;
        while (true) {
            if ((t = this.next()) == null || Token.eq("\n", t) || Token.eq(";", t) || Token.eq("&", t) || Token.eq("&&", t) || Token.eq("||", t) || Token.eq("|", t) || Token.eq("|&", t) || Token.eq("}", t) || Token.eq(")", t) || Token.eq("]", t)) {
                if (needRedirArg) {
                    throw new EOFError(this.tz.line, this.tz.column, "Expected file name for redirection", "redir", "foo");
                }
                break;
            }
            if (Token.eq("{", t)) {
                this.push(t);
                tokens.add(this.closure());
                continue;
            }
            if (Token.eq("[", t)) {
                this.push(t);
                tokens.add(this.array());
                continue;
            }
            if (Token.eq("(", t)) {
                this.push(t);
                tokens.add(this.sequence());
                continue;
            }
            if (needRedirArg) {
                redirs.add(t);
                needRedirArg = false;
                continue;
            }
            if (redirNoArg.matcher(t).matches()) {
                redirs.add(t);
                continue;
            }
            if (redirArg.matcher(t).matches()) {
                redirs.add(t);
                needRedirArg = true;
                continue;
            }
            if (redirHereDoc.matcher(t).matches()) {
                redirs.add(t);
                redirs.add(this.tz.readHereDoc(t.charAt(t.length() - 1) == '-'));
                continue;
            }
            tokens.add(t);
        }
        this.push(t);
        Statement statement = new Statement(this.whole(tokens, start), tokens, redirs);
        this.statements.add(statement);
        return statement;
    }

    public Array array() {
        Token key;
        Token start = this.start("[", "array");
        Boolean isMap = null;
        ArrayList<Token> list = new ArrayList<Token>();
        LinkedHashMap<Token, Token> map = new LinkedHashMap<Token, Token>();
        while (true) {
            if ((key = this.next()) == null) {
                throw new EOFError(this.tz.line, this.tz.column, "unexpected EOT", this.getMissing(), "]");
            }
            if (Token.eq("]", key)) break;
            if (Token.eq("\n", key)) continue;
            if (Token.eq("{", key) || Token.eq(";", key) || Token.eq("&", key) || Token.eq("&&", key) || Token.eq("||", key) || Token.eq("|", key) || Token.eq("|&", key) || Token.eq(")", key) || Token.eq("}", key) || Token.eq("=", key)) {
                throw new SyntaxError(key.line(), key.column(), "unexpected token '" + key + "' while looking for array key");
            }
            if (Token.eq("(", key)) {
                this.push(key);
                key = this.sequence();
            }
            if (Token.eq("[", key)) {
                this.push(key);
                key = this.array();
            }
            if (isMap == null) {
                Token n = this.next();
                if (n == null) {
                    throw new EOFError(this.tz.line, this.tz.column, "unexpected EOF while looking for array token", this.getMissing(), "]");
                }
                isMap = Token.eq("=", n);
                this.push(n);
            }
            if (isMap.booleanValue()) {
                this.expect("=");
                Token val = this.next();
                if (val == null) {
                    throw new EOFError(this.tz.line, this.tz.column, "unexpected EOF while looking for array value", this.getMissing(), "0");
                }
                if (Token.eq(";", val) || Token.eq("&", val) || Token.eq("&&", val) || Token.eq("||", val) || Token.eq("|", val) || Token.eq("|&", val) || Token.eq(")", key) || Token.eq("}", key) || Token.eq("=", key)) {
                    throw new SyntaxError(key.line(), key.column(), "unexpected token '" + key + "' while looking for array value");
                }
                if (Token.eq("[", val)) {
                    this.push(val);
                    val = this.array();
                } else if (Token.eq("(", val)) {
                    this.push(val);
                    val = this.sequence();
                } else if (Token.eq("{", val)) {
                    this.push(val);
                    val = this.closure();
                }
                map.put(key, val);
                continue;
            }
            list.add(key);
        }
        this.push(key);
        Token end = this.end("]");
        if (isMap == null || !isMap.booleanValue()) {
            return new Array(this.whole(start, end), list, null);
        }
        return new Array(this.whole(start, end), null, map);
    }

    protected void expectNotNull() {
        Token t = this.next();
        if (t == null) {
            throw new EOFError(this.tz.line, this.tz.column, "unexpected EOT", this.getMissing(), "0");
        }
        this.push(t);
    }

    private String getMissing() {
        return this.getMissing(null);
    }

    private String getMissing(String additional) {
        StringBuilder sb = new StringBuilder();
        LinkedList<String> stack = this.stack;
        if (additional != null) {
            stack = new LinkedList<String>(stack);
            stack.addLast(additional);
        }
        String last = null;
        int nb = 0;
        for (String cur : stack) {
            if (last == null) {
                last = cur;
                nb = 1;
                continue;
            }
            if (last.equals(cur)) {
                ++nb;
                continue;
            }
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(last);
            if (nb > 1) {
                sb.append("(").append(nb).append(")");
            }
            last = cur;
            nb = 1;
        }
        if (sb.length() > 0) {
            sb.append(" ");
        }
        sb.append(last);
        if (nb > 1) {
            sb.append("(").append(nb).append(")");
        }
        return sb.toString();
    }

    protected Token start(String str, String missing) {
        this.stack.addLast(missing);
        return this.expect(str);
    }

    protected Token end(String str) {
        Token t = this.expect(str);
        this.stack.removeLast();
        return t;
    }

    protected Token expect(String str) {
        Token start = this.next();
        if (start == null) {
            throw new EOFError(this.tz.line, this.tz.column, "unexpected EOT looking for '" + str + "", this.getMissing(), str);
        }
        if (!Token.eq(str, start)) {
            throw new SyntaxError(start.line, start.column, "expected '" + str + "' but got '" + start.toString() + "'");
        }
        return start;
    }

    protected Token whole(List<? extends Token> tokens, int index) {
        if (tokens.isEmpty()) {
            index = Math.min(index, this.tz.text().length());
            return this.tz.text().subSequence(index, index);
        }
        Token b = tokens.get(0);
        Token e = tokens.get(tokens.size() - 1);
        return this.whole(b, e);
    }

    protected Token whole(Token b, Token e) {
        return this.tz.text.subSequence(b.start - this.tz.text.start, e.start + e.length() - this.tz.text.start);
    }

    public static class Array
    extends Token {
        private final List<Token> list;
        private final Map<Token, Token> map;

        public Array(Token cs, List<Token> list, Map<Token, Token> map) {
            super(cs);
            assert (list != null ^ map != null);
            this.list = list;
            this.map = map;
        }

        public List<Token> list() {
            return this.list;
        }

        public Map<Token, Token> map() {
            return this.map;
        }
    }

    public static class Closure
    extends Token {
        private final Program program;

        public Closure(Token cs, Program program) {
            super(cs);
            this.program = program;
        }

        public Program program() {
            return this.program;
        }
    }

    public static abstract class Executable
    extends Token {
        public Executable(Token cs) {
            super(cs);
        }
    }

    public static class Operator
    extends Executable {
        public Operator(Token cs) {
            super(cs);
        }
    }

    public static class Pipeline
    extends Executable {
        private final List<Executable> tokens;

        public Pipeline(Token cs, List<Executable> tokens) {
            super(cs);
            this.tokens = tokens;
        }

        public List<Executable> tokens() {
            return this.tokens;
        }
    }

    public static class Program
    extends Token {
        private final List<Executable> tokens;

        public Program(Token cs, List<Executable> tokens) {
            super(cs);
            this.tokens = tokens;
        }

        public List<Executable> tokens() {
            return this.tokens;
        }
    }

    public static class Sequence
    extends Executable {
        private final Program program;

        public Sequence(Token cs, Program program) {
            super(cs);
            this.program = program;
        }

        public Program program() {
            return this.program;
        }
    }

    public static class Statement
    extends Executable {
        private final List<Token> tokens;
        private final List<Token> redirections;

        public Statement(Token cs, List<Token> tokens, List<Token> redirections) {
            super(cs);
            this.tokens = tokens;
            this.redirections = redirections;
        }

        public List<Token> tokens() {
            return this.tokens;
        }

        public List<Token> redirections() {
            return this.redirections;
        }
    }
}

